<?php

if (!function_exists('feeder')) {
    function feeder($data, $type = 'json')
    {
        $url = URL_FEEDER_WS2;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_POST, 1);
        $headers = array();
        if ($type == 'xml') {
            $headers[] = 'Content-Type: application/xml';
        } else {
            $headers[] = 'Content-Type: application/json';
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if ($data) {
            if ($type == 'xml') {
                $data = stringxml($data);
            } else {
                $data = json_encode($data);
            }
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        curl_close($ch);
        return json_decode($result, TRUE);
    }
}
if (!function_exists('stringxml')) {
    function stringxml($data)
    {
        $xml = new SimpleXMLElement('<?xml version="1.0"?><data></data>');
        array_to_xml($data, $xml);
        return $xml->asXML();
    }
}

if (!function_exists('array_to_xml')) {
    function array_to_xml($data, $xml_data)
    {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                $subnode = $xml_data->addChild($key);
                array_to_xml($value, $subnode);
            } else {
                $xml_data->addChild("$key", $value);
            }
        }
    }
}