<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Ws_pkkmb extends BD_Controller {
    function __construct()
    {
        parent::__construct();
        $this->load->model('Model_pkkmb','mapi');
        // $this->auth();
    }
    
    function index_post(){
        if(empty($this->post('act'))){
            $this->response(['status'=>406,'msg'=>'API method tidak boleh kosong','data'=>''],406);
        }else{
            $metname = $this->post('act');
            $cek_method = $this->mapi->getTable($metname);
            if($cek_method->num_rows()>0){
                $method = $cek_method->row_array();
                $table = $method['table_name'];
                $act = $method['method_name'];
                if(substr($act,0,8)==='GetCount'){
                    $id = $this->post('filter');
                    if ($id === null) {
                        $record = $this->mapi->getCountRecordQuery($table);
                    } else {
                        $record = $this->mapi->getCountRecordQuery($table,$id);
                    }
                    $rec = $record->num_rows();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                    
                }elseif(substr($act,0,12)==='UpdateRecord'){
                    if(empty($this->post('key'))){
                        $this->response(['status'=>406,'msg'=>'API key tidak boleh kosong','data'=>''],406);
                    }elseif(empty($this->post('record'))){
                        $this->response(['status'=>406,'msg'=>'API record tidak boleh kosong','data'=>''],406);
                    }else{
                        $key = $this->post('key');
                        $record = $this->post('record');
                        $rec = $this->mapi->updateRecord($table,$key,$record);
                        $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                    }
                }elseif(substr($act,0,12)==='DeleteRecord'){
                    if(empty($this->post('key'))){
                        $this->response(['status'=>406,'msg'=>'API key tidak boleh kosong','data'=>''],406);
                    }else{
                        $key = $this->post('key');
                        $rec = $this->mapi->deleteRecord($table,$key);
                        $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                    }
                }elseif(substr($act,0,6)==='Insert'){
                    if(empty($this->post('record'))){
                        $this->response(['status'=>406,'msg'=>'API record tidak boleh kosong','data'=>''],406);
                    }else{
                    $record = $this->post('record');
                    $rec = $this->mapi->insertRecord($table,$record);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                        
                    }
                }else{
                    if($this->post('filter')){
                        $id = $this->post('filter');
                    }else{
                        $id = '';
                    }
                    if($this->post('order')){
                        $order = $this->post('order');
                    }else{
                        $order = '';
                    }
                    if($this->post('limit')){
                        $limit = $this->post('limit');
                    }else{
                        $limit = 10;
                    }
                    if($this->post('offset')){
                        $offset = $this->post('offset');
                    }else{
                        $offset = 0;
                    }
                    
                    $record = $this->mapi->getRecordQuery($table,$id,$order,$limit,$offset);
                    $rec = $record->result_array();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }else{
                $this->response(['status'=>410,'msg'=>'API Tidak tersedia','data'=>''],410);
            }
        }
            
    }
    
    function index_get(){
        $datas = $this->mapi->getListAct();
        echo "Webservice<br>";
        foreach($datas as $data){
            echo $data['method_name'].': '.$data['method_desc'].'<br>';
        }
        // print_r($datas[0]['act']);
    }
}