<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Ws_keuangan extends BD_Controller {
    function __construct()
    {
        parent::__construct();
        $this->load->model('Model_keuangan','mkeu');
        // $this->auth();
    }
    
    function index_post(){
        if(empty($this->post('act'))){
            $this->response(['status'=>406,'msg'=>'API method tidak boleh kosong','data'=>''],406);
        }else{
            $metname = $this->post('act');
            if($metname=='GetBiayaKuliahSemester'){
                if(empty($this->post('nim')) && empty($this->post('tahun_akademik')) && empty($this->post('semester'))){
                    $this->response(['status'=>406,'msg'=>'Nim, Tahun Akademik dan Semester tidak boleh kosong','data'=>''],406);
                }else{
                    $nim = $this->post('nim');
                    $tahun_akademik = $this->post('tahun_akademik');
                    $semester = $this->post('semester');
                    $rec = $this->mkeu->GetRecordTagihan($nim,$tahun_akademik,$semester);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetPembayaran'){
                if(empty($this->post('nim')) && empty($this->post('jenis_tagihan'))){
                    $this->response(['status'=>406,'msg'=>'Nim dan Jenis Tagihan tidak boleh kosong','data'=>''],406);
                }else{
                    $nim = $this->post('nim');
                    $jenis_tagihan = $this->post('jenis_tagihan');
                    $rec = $this->mkeu->GetRecordPembayaran($nim,$jenis_tagihan);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetBiayaDaftar'){
                if(empty($this->post('id_mahasiswa'))){
                    $this->response(['status'=>406,'msg'=>'Cek kembali parameter yang dikirim','data'=>''],406);
                }else{
                    $nim = $this->post('id_mahasiswa');
                    $rec = $this->mkeu->GetRecordBiayaDaftar($nim);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetCountRegHereg'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkeu->GetTagihanRegHereg($id);
                } else {
                    $record = $this->mkeu->GetTagihanRegHereg();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }
        }
            
    }
    
    function index_get(){
        echo "Webservice Keuangan<br>GetBiayaKuliahSemester: Mendapatkan record biaya perkuliahan dalam satu semester<br>GetBiayaDaftar: Mendapatkan record biaya pendaftaran";
    }
}