<?php
if(!defined('BASEPATH')) exit('No direct script allowed');
class Model_perkuliahan extends CI_Model {
    function __construct(){
        parent::__construct();
        
    }
    private function getKelasKuliah($var = null)
    {
        $this->db->from('db_unmaku_aka.kelas_kuliah');
        if (is_array($var)) {
            $this->db->where($var);
        }
        return $this->db->get();
    }
    public function getnilai($var)
    {
        $this->db->from('db_unmaku_aka.nilai');
        $this->db->where($var);
        return $this->db->get();
    }
    
    public function getKrs($var = null)
    {
        $this->db->from('db_unmaku_aka.krs');
        if (is_array($var)) {
            $this->db->where($var);
        }
        return $this->db->get();
    }
    public function getIpsbyKrs($nim,$smt)
    {
        $sks_smt = 0;
        $ips = 0;
        $jbks = 0;
        $datas = $this->getKrs(['id_smt'=>$smt,'id_mahasiswa_pt'=>$nim]);
        foreach ($datas->result() as $key) {
            $kelas_kuliah = $this->getKelasKuliah(['id_kelas_kuliah'=>$key->id_kelas_kuliah])->row_array();
            $nilais = $this->getnilai(['id_krs'=>$key->id_krs]);
            if ($nilais->num_rows!==0) {
                $nilai = $nilais->row_array();
                $sks_smt += $kelas_kuliah['sks_mk'];
                $bobotnil = $kelas_kuliah['sks_mk'] * $nilai['nilai_indeks'];
                $jbks += $bobotnil;
            } else {
                $sks_smt += $kelas_kuliah['sks_mk'];
                $bobotnil = $kelas_kuliah['sks_mk'] * 0;
                $jbks += $bobotnil;
            }
        }
        if ($sks_smt==0) {
            # code...
            $ips =0;
        } else {
            # code...
            $ips = $jbks/$sks_smt;
        }
        return ['nim'=>$nim,'sks_smt'=>$sks_smt,'ips'=>$ips];
    }
    
    public function getRecordAjarDosen($filter=null,$order=null,$limit=null,$offset=null){
        if($filter === null || $filter === ''){
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul LIMIT ".$limit;
                    }else{
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }else{
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." LIMIT ".$limit;
                    }else{
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT b.hari_kuliah,b.jam_mulai,b.jam_selesai,a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls as nama_kelas,b.id_kelas_kuliah,a.sks_subst_tot as bobot_sks,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm as nama_dosen,c.nidn,d.kode_mk as kode_mata_kuliah,d.nm_mk as nama_mata_kuliah FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }
        return $this->db->query($query);
    }
    public function getCountRecordAjarDosen($filter=null){
        if($filter === null || $filter === ''){
            $query = "SELECT a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls,b.id_kelas_kuliah,a.sks_subst_tot,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm,c.nidn,d.kode_mk,d.nm_mk FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul";
        }else{
            $query = "SELECT a.id_ajar_dosen,b.id_smt,b.kode_prodi,b.nm_kls,b.id_kelas_kuliah,a.sks_subst_tot,a.sync_to_feeder,a.tgl_sync,a.pesan_error,c.nm_sdm,c.nidn,d.kode_mk,d.nm_mk FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.dosen c ON c.id_dosen=a.id_dosen JOIN db_unmaku_aka.mata_kuliah d ON d.id_matkul=b.id_matkul WHERE ".$filter;
        }
        return $this->db->query($query);
    }
    public function getRecordNilaiMhs($filter=null,$order=null,$limit=null,$offset=null){
        if($filter === null || $filter === ''){
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul LIMIT ".$limit;
                    }else{
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }else{
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." LIMIT ".$limit;
                    }else{
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT e.id_matkul,c.id_kelas_kuliah as id_kelas_krs,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }
        return $this->db->query($query);
    }
    public function getCountRecordNilaiMhs($filter=null){
        if($filter === null || $filter === ''){
            $query = "SELECT e.id_matkul,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul";
        }else{
            $query = "SELECT e.id_matkul,e.id_mk,c.id_kelas_kuliah,b.id_kls,a.id_mahasiswa_pt,d.id_reg_pd,a.nilai_angka,a.nilai_huruf,a.nilai_indeks,a.id_nilai,b.sks_mk FROM db_unmaku_aka.kelas_kuliah b JOIN db_unmaku_aka.krs c ON c.id_kelas_kuliah=b.id_kelas_kuliah JOIN db_unmaku_aka.nilai a ON a.id_krs=c.id_krs JOIN db_unmaku_aka.mahasiswa_pt d ON d.id_mahasiswa_pt=a.id_mahasiswa_pt JOIN db_unmaku_aka.mata_kuliah e ON e.id_matkul=b.id_matkul WHERE ".$filter;
        }
        return $this->db->query($query);
    }
    public function getListDosenPengajar($filter=null){
        if($filter === null || $filter === ''){
            $qry = "SELECT DISTINCT a.id_dosen,b.id_smt FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah";
        }else{
            $qry = "SELECT DISTINCT a.id_dosen,b.id_smt FROM db_unmaku_aka.ajar_dosen a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getListKrs($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT a.id_krs, a.id_smt, a.status_krs, a.id_kelas_kuliah, a.id_matkul,a.id_mahasiswa_pt,a.sync_to_feeder,b.sks_mk,b.kode_prodi FROM db_unmaku_aka.krs a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt";
        }else{
            $qry = "SELECT a.id_krs, a.id_smt, a.status_krs, a.id_kelas_kuliah, a.id_matkul,a.id_mahasiswa_pt,a.sync_to_feeder,b.sks_mk,b.kode_prodi FROM db_unmaku_aka.krs a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getListNilai($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT a.id_nilai,a.id_mahasiswa_pt,a.id_matkul,b.id_kelas_kuliah,b.kode_prodi,b.id_smt,a.sync_to_feeder FROM db_unmaku_aka.nilai a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt";
        }else{
            $qry = "SELECT a.id_nilai,a.id_mahasiswa_pt,a.id_matkul,b.id_kelas_kuliah,b.kode_prodi,b.id_smt,a.sync_to_feeder FROM db_unmaku_aka.nilai a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getDetailNilai($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT a.id_nilai,";
        }
        return $this->db->query($qry);
    }
    public function getMhsKrs($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT DISTINCT a.id_mahasiswa_pt FROM db_unmaku_aka.krs a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt";
        }else{
            $qry = "SELECT DISTINCT a.id_mahasiswa_pt FROM db_unmaku_aka.krs a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getMhsNilai($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT DISTINCT a.id_mahasiswa_pt FROM db_unmaku_aka.nilai a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt";
        }else{
            $qry = "SELECT DISTINCT a.id_mahasiswa_pt FROM db_unmaku_aka.nilai a JOIN db_unmaku_aka.kelas_kuliah b ON b.id_kelas_kuliah=a.id_kelas_kuliah JOIN db_unmaku_aka.mahasiswa_pt c ON c.id_mahasiswa_pt=a.id_mahasiswa_pt WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getDetailAps($filter=null){
        if($filter===null || $filter===''){
            $qry = "SELECT a.id_riwayat_akreditasi,a.no_sk_akreditasi,a.tahun_sk_akreditasi,a.peringkat,a.tanggal_daluarsa,a.status_daluarsa,a.aktif,b.prodi,b.jenjang,b.kode_prodi FROM db_sync_mk.riwayat_akreditasi_prodi a JOIN db_sync_mk.prodi b ON b.kode_prodi=a.kode_prodi";
        }else{
            $qry = "SELECT a.id_riwayat_akreditasi,a.no_sk_akreditasi,a.tahun_sk_akreditasi,a.peringkat,a.tanggal_daluarsa,a.status_daluarsa,a.aktif,b.prodi,b.jenjang,b.kode_prodi FROM db_sync_mk.riwayat_akreditasi_prodi a JOIN db_sync_mk.prodi b ON b.kode_prodi=a.kode_prodi WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    public function getPertemuan($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT * FROM db_unmaku_dhmd.bap_kuliah";
        }else{
            $qry = "SELECT * FROM db_unmaku_dhmd.bap_kuliah WHERE ".$filter;
        }
        return $this->db->query($qry);
    }
    
    public function getAvgDurasiPertemuan($filter=null){
        if($filter===null||$filter===''){
            $qry = "SELECT * FROM db_unmaku_dhmd.bap_kuliah";
        }else{
            $qry = "SELECT * FROM db_unmaku_dhmd.bap_kuliah WHERE ".$filter;
        }
        $rows = $this->db->query($qry);
        $n = 0;
        $jmldurasi = 0;
        if($rows->num_rows()>0){
            foreach($rows->result_array() as $row){
                ++$n;
                $awal = strtotime($row['mulai']);
                $akhir = strtotime($row['selesai']);
                $dur = floor(($akhir - $awal)/(60));
                if($dur<0){
                    $durasi = 0;
                }else{
                    $durasi = $dur;
                }
                $jmldurasi += $durasi;
            }
            $rerata = floor($jmldurasi/$n);
            if($rerata<0){
                return '~';
            }else{
                return $rerata;
            }
        }else{
            return 0;
        }
    }
    
    public function getDetailMhs($filter=null,$order=null,$limit=null,$offset=null){
        if($filter === null || $filter === ''){
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi LIMIT ".$limit;
                    }else{
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }else{
            if($order === null || $order === ''){
                if($limit === null){
                    $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." LIMIT ".$limit;
                    }else{
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." ORDER BY ".$order." LIMIT 10";
                }else{
                    if($offset === null){
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit;
                    }else{
                        $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter." ORDER BY ".$order." LIMIT ".$limit." OFFSET ".$offset;
                    }
                }
            }
        }
        return $this->db->query($query);
    }
    public function getCountDetailMhs($filter=null){
        if($filter === null || $filter === ''){
            $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi";
        }else{
            $query = "SELECT c.id_mhs,b.id_mahasiswa_pt,b.nipd,b.tgl_masuk_sp,b.mulai_smt,b.id_jns_daftar,a.nama_prodi,c.nm_pd,c.nik,c.tmp_lahir,c.tgl_lahir,c.jk,c.id_agama,c.jalan,c.blok,c.rt,c.rw,c.kelurahan,c.id_wil,c.no_hp,c.email,c.nm_ibu_kandung FROM db_unmaku_aka.mahasiswa_pt b JOIN db_unmaku_aka.mahasiswa c ON c.id_mhs=b.id_mhs JOIN db_unmaku_ref.prodi a ON a.kode_prodi=b.kode_prodi WHERE ".$filter;
        }
        return $this->db->query($query);
    }
    
    function getNoUrutSertifikatLdkm($thn){
        $this->db->select('MAX(RIGHT(no_sertifikat, 4)) AS kd_max');
        $this->db->from('db_sync_mk.ldkm_sertifikat');
        $this->db->where('id_pelaksanaan', $thn);
        $q = $this->db->get();
        $kd = "";
        if ($q->num_rows() == 0) {
            $kd = '0001';
        } else {
            $temp = $q->row_array();
            $tmp = ((int) $temp['kd_max']) + 1;
            $kd = sprintf("%04d", $tmp);
        }
        return $kd;
    }
    
    function getUas($npm){
        $this->db->from('db_unmaku_dhmd.bap_peserta_kuliah a');
        $this->db->join('db_unmaku_dhmd.bap_kuliah b','b.id_bap_kuliah=a.id_bap_kuliah');
        $this->db->where('a.id_mahasiswa_pt',$npm);
        $this->db->where('b.tipe_kuliah','UAS');
        return $this->db->get();
    }
    function getNilaiMhs($npm){
        $this->db->from('db_unmaku_aka.nilai a');
        $this->db->where('a.id_mahasiswa_pt',$npm);
        return $this->db->get();
    }
    function getKRsMhs($npm){
        $this->db->from('db_unmaku_aka.krs a');
        $this->db->where('a.id_mahasiswa_pt',$npm);
        $this->db->where('a.status_krs',2);
        return $this->db->get();
    }
    
    function GetMhsPt($npm){
        $this->db->from('db_unmaku_aka.mahasiswa_pt a');
        $this->db->where('a.id_mahasiswa_pt',$npm);
        return $this->db->get();
    }
    function GetProdi($kode_prodi){
        $this->db->from('db_unmaku_ref.prodi a');
        $this->db->where('a.kode_prodi',$kode_prodi);
        return $this->db->get();
    }
    function GetMhs($idmhs){
        $this->db->from('db_unmaku_aka.mahasiswa a');
        $this->db->where('a.id_mhs',$idmhs);
        return $this->db->get();
    }
    
}