<?php
if(!defined('BASEPATH')) exit('No direct script allowed');
class Model_get extends CI_Model {
    function __construct(){
        parent::__construct();
        $this->methods = [
                            ['act'=>'GetMahasiswa','table'=>DB_AKA.'mahasiswa','def'=>'Mendapatkan data Mahasiswa'],
                            ['act'=>'GetMahasiswaPt','table'=>DB_AKA.'mahasiswa_pt','def'=>'Mendapatkan data Mahasiswa PT'],
                            ['act'=>'GetAjarDosen','table'=>DB_AKA.'ajar_dosen','def'=>'Mendapatkan data Aktivitas Pengajaran Dosen'],
                            ['act'=>'GetDosen','table'=>DB_AKA.'dosen','def'=>'Mendapatkan data Dosen'],
                            ['act'=>'GetDosenPt','table'=>DB_AKA.'dosen_pt','def'=>'Mendapatkan data Dosen PT/Penugasan Dosen'],
                            ['act'=>'GetKelasKuliah','table'=>DB_AKA.'kelas_kuliah','def'=>'Mendapatkan data Kelas Kuliah'],
                            ['act'=>'GetKrs','table'=>DB_AKA.'krs','def'=>'Mendapatkan data KRS Mahasiswa'],
                            ['act'=>'GetKuliahMhs','table'=>DB_AKA.'kuliah_mahasiswa','def'=>'Mendapatkan data Kuliah Mahasiswa'],
                            ['act'=>'GetKurikulum','table'=>DB_AKA.'kurikulum','def'=>'Mendapatkan data Kurikulum'],
                            ['act'=>'GetMataKuliah','table'=>DB_AKA.'mata_kuliah','def'=>'Mendapatkan data Mata Kuliah'],
                            ['act'=>'GetMataKuliahKurikulum','table'=>DB_AKA.'mata_kuliah_kurikulum','def'=>'Mendapatkan data Mata Kuliah Kurikulum'],
                            ['act'=>'GetNilai','table'=>DB_AKA.'nilai','def'=>'Mendapatkan data Nilai Mahasiswa'],
                            ['act'=>'GetRefAgama','table'=>DB_REF.'agama','def'=>'Mendapatkan data Referensi Agama'],
                            ['act'=>'GetRefAlatTransport','table'=>DB_REF.'alat_transport','def'=>'Mendapatkan data Alat Transportasi'],
                            ['act'=>'GetRefFakultas','table'=>DB_REF.'fakultas','def'=>'Mendapatkan data Referensi Fakultas'],
                            ['act'=>'GetRefGedung','table'=>DB_REF.'gedung','def'=>'Mendapatkan data Referensi Gedung'],
                            ['act'=>'GetRefProdi','table'=>DB_REF.'prodi','def'=>'Mendapatkan data Referensi Program Studi'],
                            ['act'=>'GetRefJalurMasuk','table'=>DB_REF.'jalur_masuk','def'=>'Mendapatkan data Referensi Jalur Masuk'],
                            ['act'=>'GetRefJenisAktivitasMahasiswa','table'=>DB_REF.'jenis_aktivitas_mahasiswa','def'=>'Mendapatkan data Referensi Jenis Aktivitas Mahasiswa'],
                            ['act'=>'GetRefJenisKeluar','table'=>DB_REF.'jenis_keluar','def'=>'Mendapatkan data Referensi Jenis Keluar'],
                            ['act'=>'GetRefJenisPendaftaran','table'=>DB_REF.'jenis_pendaftaran','def'=>'Mendapatkan data Referensi Jenis Pendaftaran'],
                            ['act'=>'GetRefJenisTinggal','table'=>DB_REF.'jenis_tinggal','def'=>'Mendapatkan data Referensi Jenis Tinggal'],
                            ['act'=>'GetRefJenjangPendidikan','table'=>DB_REF.'jenjang_pendidikan','def'=>'Mendapatkan data Referensi Jenjang Pendidikan'],
                            ['act'=>'GetRefPekerjaan','table'=>DB_REF.'pekerjaan','def'=>'Mendapatkan data Referensi Pekerjaan'],
                            ['act'=>'GetRefPembiayaan','table'=>DB_REF.'pembiayaan','def'=>'Mendapatkan data Referensi Pembiayaan'],
                            ['act'=>'GetRefPenghasilan','table'=>DB_REF.'penghasilan','def'=>'Mendapatkan data Referensi Penghasilan'],
                            ['act'=>'GetRefSatuanPendidikan','table'=>DB_REF.'satuan_pendidikan','def'=>'Mendapatkan data Referensi Satuan Pendidikan'],
                            ['act'=>'GetRefSms','table'=>DB_REF.'sms','def'=>'Mendapatkan data Referensi Program Studi / SMS'],
                            ['act'=>'GetRefSemester','table'=>DB_REF.'semester','def'=>'Mendapatkan data Referensi Semester'],
                            ['act'=>'GetRefStatusMahasiswa','table'=>DB_REF.'status_mahasiswa','def'=>'Mendapatkan data Referensi Status Mahasiswa'],
                            ['act'=>'GetRefTahunAjaran','table'=>DB_REF.'tahun_ajaran','def'=>'Mendapatkan data Referensi Tahun Ajaran'],
                            ['act'=>'GetRefWilayah','table'=>DB_REF.'wilayah','def'=>'Mendapatkan data Referensi Wilayah'],
                        ];
    }
    public function getRecordWhere($table,$filter=null,$limit=null){
        $this->db->from($table);
        if($filter === null){
            if($limit === null){
                $this->db->limit(10);
            } else {
                $this->db->limit($limit);
            }
        } else {
            if($limit===null){
                $this->db->where($filter);
                $this->db->limit(10);
            } else {
                $this->db->where($filter);
                $this->db->limit($limit);
            }
        }
        return $this->db->get();
    }
    public function getRecordLike($table,$filter=null,$limit=null){
        $this->db->from($table);
        if($filter === null){
            if($limit === null){
                $this->db->limit(10);
            } else {
                $this->db->limit($limit);
            }
        } else {
            if($limit===null){
                $this->db->like($filter);
                $this->db->limit(10);
            } else {
                $this->db->like($filter);
                $this->db->limit($limit);
            }
        }
        return $this->db->get();
    }
    public function getRecordQuery($table,$filter=null,$order=null,$limit=null,$offset=null){
        if($filter === null){
            if($order === null){
                if($limit === null){
                    $query =    "SELECT * 
                                FROM ".$table." 
                                LIMIT 10";
                } else {
                    if($offset === null){
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    LIMIT ".$limit;
                    } else {
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    LIMIT ".$limit.",".$offset;
                    }
                }
            }else{
                if($limit === null){
                    $query =    "SELECT * 
                                FROM ".$table." 
                                ORDER BY ".$order.
                                " LIMIT 10";
                } else {
                    if($offset === null){
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    ORDER BY ".$order.
                                    " LIMIT ".$limit;
                    } else {
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    ORDER BY ".$order.
                                    " LIMIT ".$limit.",".$offset;
                    }
                }
            }
                
        } else {
            if($order === null){
                if($limit===null){
                    $query =    "SELECT * 
                                FROM ".$table." 
                                WHERE ".$filter." 
                                LIMIT 10";
                } else {
                    if($offset === null){
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    WHERE ".$filter." 
                                    LIMIT ".$limit;
                    }else{
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    WHERE ".$filter." 
                                    LIMIT ".$limit.",".$offset;
                    }   
                }
            }else{
                if($limit===null){
                    $query =    "SELECT * 
                                FROM ".$table." 
                                WHERE ".$filter." 
                                ORDER BY ".$order.
                                "LIMIT 10";
                } else {
                    if($offset === null){
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    WHERE ".$filter." 
                                    ORDER BY ".$order.
                                    " LIMIT ".$limit;
                    }else{
                        $query =    "SELECT * 
                                    FROM ".$table." 
                                    WHERE ".$filter." 
                                    ORDER BY ".$order.
                                    " LIMIT ".$limit.",".$offset;
                    }
                        
                }
            }
                
        }
        
        return $this->db->query($query);
    }
    
    public function getTable($act){
        foreach($this->methods as $key){
            if($key['act']===$act){
                $table = $key['table'];
            }
        }
        return $table;
    }
    public function getListAct(){
        $act = array();
        foreach($this->methods as $key){
            $act[] = $key['act'];
        }
        return $act;
    }
    
}