<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Ws_perkuliahan_pasca extends BD_Controller {
    function __construct()
    {
        parent::__construct();
        $this->load->model('Model_perkuliahan_pasca','mkul');
        // $this->auth();
    }
    
    function index_post(){
        if(empty($this->post('act'))){
            $this->response(['status'=>406,'msg'=>'API method tidak boleh kosong','data'=>''],406);
        }else{
            $metname = $this->post('act');
            if($metname=='GetIpsKuliah'){
                if(empty($this->post('nim')) && empty($this->post('id_semester'))){
                    $this->response(['status'=>406,'msg'=>'Nim dan Semester tidak boleh kosong','data'=>''],406);
                }else{
                    $nim = $this->post('nim');
                    $semester = $this->post('id_semester');
                    $rec = $this->mkul->getIpsbyKrs($nim,$semester);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetNoUrutSertifikatLdkm'){
                if(empty($this->post('id_pelaksanaan'))){
                    $this->response(['status'=>406,'msg'=>'Id Pelaksanaan tidak boleh kosong','data'=>''],406);
                }else{
                    $thn = $this->post('id_pelaksanaan');
                    $rec = $this->mkul->getNoUrutSertifikatLdkm($thn);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetListDetailMahasiswaPt'){
                if($this->post('filter')){
                        $id = $this->post('filter');
                    }else{
                        $id = '';
                    }
                    if($this->post('order')){
                        $order = $this->post('order');
                    }else{
                        $order = '';
                    }
                    if($this->post('limit')){
                        $limit = $this->post('limit');
                    }else{
                        $limit = 10;
                    }
                    if($this->post('offset')){
                        $offset = $this->post('offset');
                    }else{
                        $offset = 0;
                    }
                    
                    $record = $this->mkul->getDetailMhs($id,$order,$limit,$offset);
                    $rec = $record->result_array();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountDetailMahasiswaPt'){
                $id = $this->post('filter');
                if ($id === null) {
                    $record = $this->mkul->getCountDetailMhs();
                } else {
                    $record = $this->mkul->getCountDetailMhs($id);
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListDetailAjarDosen'){
                if($this->post('filter')){
                        $id = $this->post('filter');
                    }else{
                        $id = '';
                    }
                    if($this->post('order')){
                        $order = $this->post('order');
                    }else{
                        $order = '';
                    }
                    if($this->post('limit')){
                        $limit = $this->post('limit');
                    }else{
                        $limit = 10;
                    }
                    if($this->post('offset')){
                        $offset = $this->post('offset');
                    }else{
                        $offset = 0;
                    }
                    
                    $record = $this->mkul->getRecordAjarDosen($id,$order,$limit,$offset);
                    $rec = $record->result_array();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountAjarDosen'){
                $id = $this->post('filter');
                if ($id === null) {
                    $record = $this->mkul->getCountRecordAjarDosen();
                } else {
                    $record = $this->mkul->getCountRecordAjarDosen($id);
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListDosenPengajar'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListDosenPengajar($id);
                } else {
                    $record = $this->mkul->getListDosenPengajar();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountDosenPengajar'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListDosenPengajar($id);
                } else {
                    $record = $this->mkul->getListDosenPengajar();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListKrs'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListKrs($id);
                } else {
                    $record = $this->mkul->getListKrs();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountKrs'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListKrs($id);
                } else {
                    $record = $this->mkul->getListKrs();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListNilai'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListNilai($id);
                } else {
                    $record = $this->mkul->getListNilai();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountNilai'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getListNilai($id);
                } else {
                    $record = $this->mkul->getListNilai();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListMhsNilai'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getMhsNilai($id);
                } else {
                    $record = $this->mkul->getMhsNilai();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountMhsNilai'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getMhsNilai($id);
                } else {
                    $record = $this->mkul->getMhsNilai();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListMhsKrs'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getMhsKrs($id);
                } else {
                    $record = $this->mkul->getMhsKrs();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountMhsKrs'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getMhsKrs($id);
                } else {
                    $record = $this->mkul->getMhsKrs();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetListAPS'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getDetailAps($id);
                } else {
                    $record = $this->mkul->getDetailAps();
                }
                $rec = $record->result_array();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountAPS'){
                if($this->post('filter')){
                    $id = $this->post('filter');
                    $record = $this->mkul->getDetailAps($id);
                } else {
                    $record = $this->mkul->getDetailAps();
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountPertemuan'){
                if(empty($this->post('id_kelas_kuliah'))){
                    $this->response(['status'=>406,'msg'=>'Cek kembali parameter yang dikirim','data'=>''],406);
                }else{
                    $id_kelas = $this->post('id_kelas_kuliah');
                    $filter = "id_kelas_kuliah='".$id_kelas."'";
                    $rec = $this->mkul->getPertemuan($filter)->num_rows();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetRerataDurasiPertemuan'){
                if(empty($this->post('id_kelas_kuliah'))){
                    $this->response(['status'=>406,'msg'=>'Cek kembali parameter yang dikirim','data'=>''],406);
                }else{
                    $id_kelas = $this->post('id_kelas_kuliah');
                    $filter = "id_kelas_kuliah='".$id_kelas."'";
                    $rec = $this->mkul->getAvgDurasiPertemuan($filter);
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
                }
            }elseif($metname=='GetListDetailNilaiMhs'){
                if($this->post('filter')){
                        $id = $this->post('filter');
                    }else{
                        $id = '';
                    }
                    if($this->post('order')){
                        $order = $this->post('order');
                    }else{
                        $order = '';
                    }
                    if($this->post('limit')){
                        $limit = $this->post('limit');
                    }else{
                        $limit = 10;
                    }
                    if($this->post('offset')){
                        $offset = $this->post('offset');
                    }else{
                        $offset = 0;
                    }
                    
                    $record = $this->mkul->getRecordNilaiMhs($id,$order,$limit,$offset);
                    $rec = $record->result_array();
                    $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }elseif($metname=='GetCountDetailNilaiMhs'){
                $id = $this->post('filter');
                if ($id === null) {
                    $record = $this->mkul->getCountRecordNilaiMhs();
                } else {
                    $record = $this->mkul->getCountRecordNilaiMhs($id);
                }
                $rec = $record->num_rows();
                $this->response(['status'=>200,'msg'=>'','data'=>$rec],200);
            }
            
        }
            
    }
    
    function index_get(){
        echo "Webservice Perkuliahan<br>GetIpsKuliah: Mendapatkan sks semester dan IPS (Indeks Prestasi Semester)<br>GetListDetailAjarDosen: Mendapatkan daftar Detail Dosen Pengajar Matakuliah<br>GetCountAjarDosen: Mendapatkan jumlah record Dosen Pengajar Mata Kuliah<br>GetListDosenPengajar: Mendapatkan daftar dosen pengajar<br>";
    }
}